/*
 * ObjectCollection.h
 *
 * Created 8/7/2009 By Johnny Huynh
 *
 * Version 00.00.02 8/19/2009
 *
 * Copyright Information:
 * All content copyright  2009 Johnny Huynh. All rights reserved.
 */
 
 #ifndef OBJECT_COLLECTION_H
 #define OBJECT_COLLECTION_H
 
 template <typename T> class ObjectCollection;
 
 #include "Object.h"
 #include "pointerTo.h"
 
 #include "global.h"
 #include "StringConversion.h"
 
 #include "MapCollection.h"
 #include <map>
 
 /**
  * Class specification for ObjectCollection
  */
 template <typename T>
 class ObjectCollection : public MapCollection< std::string, PT(Object<T>) >
 {
 // Public Encapsulated Classes
 public:
    //class iterator;
 
 // Data Members
 protected:
    typedef MapCollection< std::string, PT(Object<T>) > MapCollection;
    typedef std::map< std::string, PT(Object<T>), std::less<std::string> > ObjectMap;
    
 // Local Functions
 public:
    ObjectCollection();
    ObjectCollection( const ObjectCollection<T>& oc );
    virtual ~ObjectCollection();
    //inline ObjectCollection<T>& operator=( const ObjectCollection<T>& oc );
    //inline typename ObjectCollection<T>::iterator begin();
    //inline typename ObjectCollection<T>::iterator end();
    virtual inline void add( Object<T> * object_Ptr );
    virtual inline void add( const std::string& key, Object<T> * object_Ptr );
    //inline void clear();
    virtual inline Object<T>* get( const std::string& key );
    virtual inline Object<T>* get( const NodePath& node_path );
    virtual inline void remove( const std::string& key );
    virtual inline void remove( const NodePath& node_path );
 
 // Private Functions
 private:
    
 // Friend Functions
 public:
    
 // Public Encapsulated Classes
 public:
    /**
     *  Class specification for ObjectCollection<T>::iterator
     *
     *  CAVEAT:
     *  The operator->() has been overloaded to give direct access to Object<T>
     *  for convenience. To access PT(Object<T>), for invoking PointerTo functions, 
     *  deference the iterator using operator*() (e.g. (*itr).is_null()).
     */
    /*virtual class iterator
    {
    friend class ObjectCollection<T>;
    
    // Data members
    private:
        typename ObjectMap::iterator _object_Itr;
    
    // Local Functions
    public:
        iterator() { }
        iterator( const iterator& itr ) : _object_Itr( itr._object_Itr ) { }
        ~iterator() { }
        inline iterator& operator=( const iterator& itr ) { _object_Itr = itr._object_Itr; return *this; }
        inline bool operator==( const iterator& itr ) { return _object_Itr == itr._object_Itr; }
        inline bool operator!=( const iterator& itr ) { return _object_Itr != itr._object_Itr; }
        inline PT(Object<T>)& operator*() const { return (*this->_object_Itr).second; } // dereference operator
        inline PT(Object<T>)& operator->() const { return (*this->_object_Itr).second; } // member access operator
        inline iterator& operator++() { ++_object_Itr; return *this; } // post-increment
        inline iterator& operator++(int) { ++_object_Itr; return *this; } // pre-increment
        inline iterator& operator--() { --_object_Itr; return *this; } // post-decrement
        inline iterator& operator--(int) { --_object_Itr; return *this; } // pre-decrement
        
    // Private Functions
    private:
        iterator( const typename ObjectMap::iterator& object_Itr ) : _object_Itr( object_Itr ) { }
    };*/
 };
 
 /** LOCAL FUNCTIONS **/
 
 /**
  * Constructor
  */
 template <typename T>
 ObjectCollection<T>::ObjectCollection()
                     : MapCollection()
 {
    
 }
 
 /**
  * Copy Constructor
  */
 template <typename T>
 ObjectCollection<T>::ObjectCollection( const ObjectCollection<T>& oc )
          : MapCollection( oc )
 {
    
 }
 
 /**
  * Destructor
  */
 template <typename T>
 ObjectCollection<T>::~ObjectCollection()
 {
    
 }
 
 /**
  * add() adds the specified Object pointer to this ObjectCollection.
  *
  * @param (Object<T> *) object_Ptr
  */
 template <typename T>
 inline void ObjectCollection<T>::add( Object<T> * object_Ptr )
 {
    add( StringConversion::to_str( object_Ptr->get_key() ), object_Ptr );
 }
 
 /**
  * add() adds the specified Object pointer to this ObjectCollection, using the specified key.
  *
  * @param (const std::string&) key
  * @param (Object<T> *) object_Ptr
  */
 template <typename T>
 inline void ObjectCollection<T>::add( const std::string& key, Object<T> * object_Ptr )
 {
    if ( object_Ptr != NULL )
    {
        MapCollection::add( key, object_Ptr );
        //_values.insert( ObjectMap::value_type( key, object_Ptr ) );
        //printf( "%1d\n", _object_Ptrs.find( object_Ptr->get_key() )->second.is_null() );
    }
 }
 
 /**
  * get() returns a pointer to the Object that has the specified key.
  *
  * @param (const std::string&) key
  * @return Object<T>*
  */
 template <typename T>
 inline Object<T>* ObjectCollection<T>::get( const std::string& key )
 {
    /*ObjectMap::iterator object_Itr( _object_Ptrs.find( key ) );
    
    // if the node_path is not an Object in _object_Ptrs
    if ( object_Itr == _object_Ptrs.end() )
        return NULL;
    else // the Object matching the node_path is found in _object_Ptrs
        return object_Itr->second;*/
    //return MapCollection::get( key );
    MapCollection::iterator object_Itr( MapCollection::find( key ) );
    
    // if the Object is not found in ObjectCollection
    if ( object_Itr == MapCollection::end() )
        return NULL;
    else // the Object matching the key is found in the ObjectCollection
        return *object_Itr;
 }
 
 /**
  * get() returns a pointer to the Object matching the specified node_path.
  * If the specified node_path is not an Object contained within this collection,
  * then NULL is returned. This only works if the Object was stored using the 
  * Object's key.
  *
  * @param (const NodePath&) node_path
  * @return Object<T>*
  */
 template <typename T>
 inline Object<T>* ObjectCollection<T>::get( const NodePath& node_path )
 {
    return ObjectCollection<T>::get( StringConversion::to_str( node_path.get_key() ) );
 }
 
 /**
  * remove() removes the Object that has the specified key from this ObjectCollection.
  *
  * @param (const std::string&) key
  */
 template <typename T>
 inline void ObjectCollection<T>::remove( const std::string& key )
 {
    /*ObjectMap::const_iterator object_Itr( _object_Ptrs.find( key ) );
    
    // if the node_path is not an Object in _object_Ptrs
    if ( object_Itr == _object_Ptrs.end() )
        return; 
    else // the Object matching the node_path is found in _object_Ptrs
    {
        _object_Ptrs.erase( object_Itr );
    }*/
    MapCollection::remove( key );
 }
 
 /**
  * remove() removes the Object matching the specified node_path
  * from this ObjectCollection. This only works if the Object was 
  * stored using the Object's key.
  *
  * @param (const NodePath&) node_path
  */
 template <typename T>
 inline void ObjectCollection<T>::remove( const NodePath& node_path )
 {
    remove( StringConversion::to_str( node_path.get_key() ) );
 }
 
 /** FRIEND FUNCTIONS **/
 
 #endif // OBJECT_COLLECTION_H